/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.ccfw.pa.ar;

import com.ibm.hsc.ccfw.pa.event.SurveillanceNotificationDataEvent;
import com.ibm.hwmca.base.pa.ar.DistributedDataEventAnalysisRoutine;
import com.ibm.hwmca.base.pa.ar.XMLHelper;
import com.ibm.hwmca.base.pa.event.SystemAnalysisCompleteEvent;
import com.ibm.hwmca.fw.log.Log;
import com.ibm.hwmca.fw.pa.event.ProblemAnalysisEvent;
import com.ibm.hwmca.fw.pa.event.ProblemAnalysisEventListener;
import com.ibm.hwmca.fw.pa.incident.Incident;
import com.ibm.hwmca.fw.pa.incident.IncidentPool;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.p.pa.event.SaelDataEvent;
import com.ibm.hwmca.p.pa.fru.PIFru;
import com.ibm.hwmca.p.pa.problem.PIProblem;
import com.ibm.hwmca.xfw.pa.domain.DistributedAnalysisDomain;
import com.ibm.hwmca.xfw.pa.event.CommonDataEvent;
import com.ibm.hwmca.xfw.pa.event.CommonServiceAREvent;
import com.ibm.hwmca.xfw.pa.event.DistributedDataEvent;
import com.ibm.hwmca.xfw.pa.fru.CommonPaFru;

public class PartitionFSPSurveillanceAnalysisRoutine
extends DistributedDataEventAnalysisRoutine
implements ProblemAnalysisEventListener {
    private static final String TRACE_MASKT = "PPAPSART";
    private static final String TRACE_MASKF = "PPAPSARF";
    private static final String TRACE_MASKD = "PPAPSARD";
    public static final String HMC_TO_FSP_FAILURE_PN = "SPNETWK";
    public static final String HMC_TO_FSP_LOCATION_SUFFIX = "-SP-LAN";
    public static final String HMC_TO_PART_FAILURE_PN = "PTNNTWK";
    public static final String HMC_TO_PART_LOCATION_SUFFIX = "-SPOT-LAN-CONNECTION";
    public static final String HMC_TO_PART_LOCATION_SUFFIX1 = "-PARTITION";
    public static final String HMC_TO_PART_LOCATION_SUFFIX2 = "-LAN-CONNECTION";
    public static final String HMC_TO_ALL_FAILURE_PN = "SYSNTWK";
    public static final String HMC_TO_ALL_LOCATION_SUFFIX = "-LAN-CONNECTIONS";

    public PartitionFSPSurveillanceAnalysisRoutine() {
        Trace.trace((String)TRACE_MASKD, (Object)"<-> ctor new PartitionFSPSurveillanceAR 05/24/2004 ");
    }

    public void analyze(ProblemAnalysisEvent problemAnalysisEvent) {
        CharSequence charSequence;
        Trace.trace((String)TRACE_MASKT, (Object)"--> PartitionFSPSurveillanceAnalysisRoutine.analyze() 05/24/2004");
        DistributedDataEvent distributedDataEvent = (DistributedDataEvent)problemAnalysisEvent;
        DistributedAnalysisDomain distributedAnalysisDomain = (DistributedAnalysisDomain)this.getEventDomain((CommonDataEvent)distributedDataEvent);
        if (distributedAnalysisDomain == null) {
            Trace.trace((String)TRACE_MASKT, (Object)"<-- analyze: eventDomain null analyze()");
            Log log = new Log(-86, 70, 0, "PA EVT DSCRD", null, null, null, null);
            String string = "couldn't find domain: " + distributedDataEvent.getDomainId().getDID();
            log.add((byte)3, (Object)string);
            log.log();
            return;
        }
        if (distributedDataEvent.getRefcode().length() == 0) {
            Trace.trace((String)TRACE_MASKT, (Object)"<-- analyze: refcode is empty just leave");
            Log log = new Log(-86, 70, 0, "PA EVT DSCRD", null, null, null, null);
            String string = "No refcode for surveillance, no error: " + distributedDataEvent.getDomainId().getDID();
            log.add((byte)3, (Object)string);
            log.log();
            return;
        }
        this.processEvent(distributedDataEvent);
        if (this.anIncident == null) {
            Log log = new Log(-86, 70, 0, "PA EVT DSCRD", null, null, null, null);
            String string = "couldn't create incident";
            log.add((byte)3, (Object)string);
            log.log();
            Trace.trace((String)TRACE_MASKT, (Object)"<-- analyze(): couldn't create incident");
            return;
        }
        PIProblem pIProblem = (PIProblem)this.anIncident.getProblem();
        if (pIProblem == null) {
            Log log = new Log(-86, 70, 0, "PA EVT DSCRD", null, null, null, null);
            String string = "couldn't create problem";
            log.add((byte)3, (Object)string);
            log.log();
            Trace.trace((String)TRACE_MASKT, (Object)"<-- analyze(): couldn't create problem");
            return;
        }
        if (problemAnalysisEvent instanceof SaelDataEvent && ((SaelDataEvent)problemAnalysisEvent).isSurveillanceError() || problemAnalysisEvent instanceof SurveillanceNotificationDataEvent) {
            Trace.trace((String)TRACE_MASKD, (Object)"Surveillance Event continue processing");
            pIProblem.setServiceableEventText(distributedDataEvent.getSvcEventText());
            Trace.trace((String)TRACE_MASKD, (Object)("ourProblem.setServiceableEventText(" + distributedDataEvent.getSvcEventText() + ")"));
            pIProblem.setServiceableEventCreationTimestamp(System.currentTimeMillis());
            pIProblem.setHMCLocale(distributedDataEvent.getHMCLocales());
            charSequence = new StringBuffer();
            XMLHelper.outToXML((Object)pIProblem, (StringBuffer)charSequence, pIProblem.getClass());
            Trace.trace((String)TRACE_MASKD, (Object)("PIProblem.outToXML to show what we have added so far (common info)" + charSequence));
            pIProblem.setNotifyCustomer(true);
            pIProblem.setCallHome(false);
            charSequence = new PIFru();
            pIProblem.addPart((CommonPaFru)charSequence);
            charSequence.setFruClass(12);
            if (pIProblem.getRefcode().equals("B3030011") || pIProblem.getRefcode().equals("B3030012") || pIProblem.getRefcode().equals("B3030001")) {
                charSequence.setPartNumber(HMC_TO_FSP_FAILURE_PN);
                charSequence.addLocation(((DistributedDataEvent)problemAnalysisEvent).getReportingSystem() + HMC_TO_FSP_LOCATION_SUFFIX);
            }
            if (pIProblem.getRefcode().equals("B3030002")) {
                charSequence.setPartNumber(HMC_TO_PART_FAILURE_PN);
                charSequence.addLocation(((DistributedDataEvent)problemAnalysisEvent).getReportingSystem() + HMC_TO_PART_LOCATION_SUFFIX);
            }
            if (pIProblem.getRefcode().equals("B3030008")) {
                charSequence.setPartNumber(HMC_TO_ALL_FAILURE_PN);
                charSequence.addLocation(((DistributedDataEvent)problemAnalysisEvent).getReportingSystem() + HMC_TO_ALL_LOCATION_SUFFIX);
            }
        } else {
            Trace.trace((String)TRACE_MASKD, (Object)"Non-Surveillance error discarded");
            Trace.trace((String)TRACE_MASKD, (Object)"<-- PartitionFSPSurveillanceAnlaysisRoutine.analyze()");
            return;
        }
        charSequence = ((CommonDataEvent)problemAnalysisEvent).getIncidentPoolId();
        IncidentPool incidentPool = this.getPendingIncidentPool((String)charSequence);
        if (incidentPool != null) {
            Trace.trace((String)TRACE_MASKD, (Object)"adding to our analysis pool");
            incidentPool.add((Incident)this.anIncident);
        } else {
            Trace.trace((String)TRACE_MASKD, (Object)"no pool to add too");
        }
        IncidentPool incidentPool2 = this.swapPendingIncidentPool((String)charSequence);
        this.postServiceAREvent((CommonServiceAREvent)new SystemAnalysisCompleteEvent((Object)this), ((CommonDataEvent)problemAnalysisEvent).getSystem(), incidentPool2.getPoolId());
        Trace.trace((String)TRACE_MASKT, (Object)"<-- PartitionFSPSurveillanceAnlaysisRoutine.analyze()");
    }

    private String subsystemIdToRefcode(int n) {
        String string = "";
        if (n == 122) {
            string = "B3030011";
        } else if (n == 123) {
            string = "B3030012";
        } else if (n == 124) {
            string = "B3030001";
        } else if (n == 125) {
            string = "B3030002";
        } else if (n != 126 && n == 127) {
            string = "B3030008";
        }
        return string;
    }
}

